/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.gtwy;
import cnrg.itx.datax.*;
import cnrg.itx.datax.devices.*;
import cnrg.itx.signal.*;

/**
 * This class controls the second channel in a data connection.  Second channel's only purpose is to send
 * data to the phone.
 * 
 * @author James Wann
 * @version 1.0a
 * @see java.lang.Runnable
 */
public class PlayChannel implements Runnable
{
	static
	{
		System.loadLibrary("Dialogic");
	}
	
	/**
	 * The Line instance corresponding to PlayChannel's line.
	 */
	private Line myLine;
	
	/**
	 * @param lin the <code>Line</code> instance corresponding to <code>PlayChannel's</code> line.
	 * Contains information regarding that line.
	 * @see Line
	 */
	protected PlayChannel(Line lin)
	{
		myLine = lin;
	}
	
	public void run()
	{
		int myLineNumber = myLine.getLineNumber();
		int myChDev = myLine.getSecondDev();
		
		playPacket(myChDev, myLineNumber);
	}
	
	/**
	 * Plays voice data from a buffer to a phone.
	 * 
	 * @param chDev the channel's device handler.
	 * @param lineNumber the channel's corresponding line number.
	 */
	private native void playPacket(int chDev, int lineNumber);
}